# Edited 230814 Z direction for symbols points outwards

from convsf_classes import convSF
from convsf_classes import entmat
from convsf_classes import vertexdef
from convsf_classes import multidef

# drawlocus
# get3Dpolycentroid
# closegroup
# offsetlocus
# getspacing
# getmatrix

# =================================createfromshape
# createfrom3Dpoly
# createfromline
# processcurve
# createfromcurve
# createfrom2Dpoly


import vs

X = 0
Y = 1
Z = 2

# ===============================================================Global utils
def mm(num):
	return vs.GetPrefReal(152) * num / 25.4

#def chksymbol(symname):
#	if vs.GetObject(symname) == vs.Handle(0):
#		vs.BeginSym(symname)
#		vs.Locus(0,0)
#		vs.EndSym()

def drawlocus(ptloc,u,v,w):
	vs.Symbol(convSF.symname,ptloc,0)
	# vs.Locus(0,0)
	objH = vs.LNewObj()

#	w = (-w[X],-w[Y],-w[Z]) # Z direction points outwards added 230814
#	v = (-v[X],-v[Y],-v[Z])

	if convSF.Offsetset and convSF.Offset != [0,0,0]:
		ptloc = offsetlocus(ptloc,convSF.Offset,u,v,w)
	
	if convSF.Rotationset:
		btest = vs.SetEntityMatrix(objH,ptloc,convSF.Rotation[X],convSF.Rotation[Y],convSF.Rotation[Z])
	else:
		btest = vs.SetEntityMatrixN(objH, u, v, w, ptloc)

	if not btest:
		vs.DelObject(objH)

#drawlocus

def closegroup(grpH):
	vs.EndGroup()
	if vs.GetTypeN(grpH) == 11:
		if vs.FInGroup(grpH) == vs.Handle(0):
			vs.DelObject(grpH)
#closegroup

def offsetlocus(locpos,offset,u,v,w):
	if offset[X] != 0:
		u = (u[X] * offset[X],u[Y] * offset[X],u[Z] * offset[X])
		locpos = (locpos[X] + u[X],locpos[Y] + u[Y],locpos[Z] + u[Z])

	if offset[Y] != 0:
		v = (v[X] * offset[Y],v[Y] * offset[Y],v[Z] * offset[Y])
		locpos = (locpos[X] + v[X],locpos[Y] + v[Y],locpos[Z] + v[Z])

	if offset[Z] != 0:
		w = (w[X] * offset[Z],w[Y] * offset[Z],w[Z] * offset[Z])
		locpos = (locpos[X] + w[X],locpos[Y] + w[Y],locpos[Z] + w[Z])

	return locpos
#offsetlocus

def getspacing(spacesetout,startpos,startoffset,edgelen):
	
	if spacesetout == convSF.kMIDDLE:
		segstartpos = startpos + edgelen / 2
		spaceno = 1
		spacing = 0
	else:
		spacing = convSF.Spacing
		if spacing > 0:
			spaceno = vs.Trunc(edgelen/spacing)
		else:
			spaceno = 0
	
		if spacesetout == convSF.kSTART:
			segstartpos = startpos + startoffset
			spaceno += 1
	
		elif spacesetout == convSF.kEND:
			segstartpos = startpos + startoffset + edgelen - (spacing * spaceno)
			spaceno  += 1
	
		elif spacesetout == convSF.kCENTRED:
			segstartpos = startpos + startoffset + (edgelen - spaceno * spacing)/2
			spaceno  += 1
	
		else: # kEQUAL
			segstartpos = startpos + startoffset
			spacing  = edgelen / (spaceno+1)
			spaceno += 2

	return (segstartpos,spaceno,spacing)
#getspacing

def get3Dpolycentroid(objH):
	closed = vs.IsPolyClosed(objH)
	if not closed:
		vs.SetPolyClosed(objH,True)

	btest,x1,y1,z1 = vs.Centroid3D(objH) # fails if poly open
	baselevel, thickness = vs.GetLayerElevation(vs.GetLayer(objH))
	z1 += baselevel
	
	if not closed:
		vs.SetPolyClosed(objH,False)

	return (x1,y1,z1)
#get3Dpolycentroid

def getmatrix(pt1,pt2,pt3):
	# pt1 = start pos
	# pt2 = end pos
	# pt3 = origin pos

	v1 = (pt2[X]-pt1[X],pt2[Y]-pt1[Y],pt2[Z]-pt1[Z])
	v2 = (pt3[X]-pt1[X],pt3[Y]-pt1[Y],pt3[Z]-pt1[Z])
	v3 = vs.CrossProduct(v1, v2)
	v2 = vs.CrossProduct(v1, v3)

	mati = vs.UnitVec(v1)
	matj = vs.UnitVec(v2)
	matk = vs.UnitVec(v3)
	
	linelen = vs.Distance3D(pt1[X],pt1[Y],pt1[Z],pt2[X],pt2[Y],pt2[Z])

	return(mati,matj,matk,linelen)

# getmatrix


# ===============================================================Global utils


# ===============================================================Shape conversion
def createfromshape(objH,objty):
	objty = vs.GetTypeN(objH)
	if objty in [2,3,4,5,6,13,21,25,111]:
		vs.DSelectAll()
#		chksymbol(convSF.symname)
	
		if objty == 25: # 3D polygon
			createfrom3Dpoly(objH)
	
		elif objty == 2: # Line
			createfromline(objH)
		
		elif objty == 111: # Nurbs curve
			processcurve(objH)
	
		elif objty in [5,21]: # 2D polygon/polyline
			createfrom2Dpoly(objH)
			
		elif objty in [3,4,6,13]: # 2D rect/oval/arc/rrect
			polyH = vs.MakePolyline(objH)
			createfrom2Dpoly(polyH)
			vs.DelObject(polyH)

# =================================createfromshape

def createfrom3Dpoly(srcpolyH):

	def getpolydef(objH,closed):
		polydefs = []
		cnt = vs.GetVertNum(objH)

		if cnt >= 3: #in one plane
			# Note unclosed 3Dpolys do not give a centroid
			origpos = get3Dpolycentroid(objH)
			startpos = vs.GetPolyPt3D(objH,0)
			firstpos = startpos
	
			for i in range(cnt):
				if i < (cnt-1):
					endpos = vs.GetPolyPt3D(objH,i+1)
				else:
					endpos = firstpos

				u,v,w,linelen = getmatrix(startpos,endpos,origpos)
				if not((i==cnt) and closed): # added 230210
					polydefs.append((startpos,u,v,w,linelen))
				
				startpos = endpos

		return (origpos,polydefs)
	
	#getpolydef

	def drawlines3D(polydefs,closed):
		cnt = len(polydefs)
		if not closed:
			cnt -= 1
		
		for i in range(cnt):
			startpos,u,v,w,linelen = polydefs[i]
			vs.MoveTo(0,0)
			vs.LineTo(linelen,0)
			objH = vs.LNewObj()
			vs.SetEntityMatrixN(objH,u,v,w,startpos)

	def drawvertices3D(polydefs,closed):
		cnt = len(polydefs)
		for i in range(cnt):
			startpos,u,v,w,linelen = polydefs[i]
			if i == 0:
				if closed:
					temppos,u2,v2,w2,linelen = polydefs[cnt-1]
					u = vs.UnitVec((u[X]+u2[X],u[Y]+u2[Y],u[Z]+u2[Z]))
			elif not closed and (i == cnt-1):
				temppos,u,v2,w2,linelen = polydefs[i-1]
			else:
				temppos,u2,v2,w2,linelen = polydefs[i-1]
				u = vs.UnitVec((u[X]+u2[X],u[Y]+u2[Y],u[Z]+u2[Z]))
			
			v = vs.CrossProduct(u, w)
			
			drawlocus(startpos,u,v,w)

	def drawedges3D(polydefs,closed):
		
		def modstartpos(startpos,u,offset):
			return (startpos[X]+u[X]*offset,startpos[Y]+u[Y]*offset,startpos[Z]+u[Z]*offset)
		
		def drawmiddle(edge):
			startpos,u,v,w,pathlen = edge
			startpos = modstartpos(startpos,u,pathlen/2)
			
			drawlocus(startpos,u,v,w)

		def drawspaced(edge,setout):
			spacing  = convSF.Spacing
			if (spacing > 0):
				startoff = convSF.Startoffset
				endoff   = convSF.Endoffset
	
				startpos,u,v,w,linelen = edge
				pathlen = linelen - startoff - endoff
				spaceno = vs.Trunc(pathlen/spacing)

				startvec = (u[X]*startoff,u[Y]*startoff,u[Z]*startoff)
				startpos = (startpos[X]+startvec[X],startpos[Y]+startvec[Y],startpos[Z]+startvec[Z])

				if setout == convSF.kEND:
					startpos = modstartpos(startpos,u, pathlen - spacing * spaceno)
				elif setout == convSF.kCENTRED:
					startpos = modstartpos(startpos,u, (pathlen - spaceno * spacing)/2)
				elif setout == convSF.kEQUAL:
					spacing  = pathlen / (spaceno+1)
					spaceno += 1

				spacingvec = (u[X]*spacing,u[Y]*spacing,u[Z]*spacing)
				drawlocus(startpos,u,v,w) # first

				for i in range(spaceno):
					startpos = (startpos[X]+spacingvec[X],startpos[Y]+spacingvec[Y],startpos[Z]+spacingvec[Z])
					drawlocus(startpos,u,v,w)
					

	# drawedges3D
		cnt = len(polydefs)
		if not closed:
			cnt -= 1

		setout = convSF.Spacesetout
		for i in range(cnt):
			edge = polydefs[i]
			startpos,u,v,w,linelen = edge
			if setout == convSF.kMIDDLE:
				drawmiddle(edge)
			else:
				drawspaced(edge,setout)
	# drawedges3D

	def drawfaces3D(polydefs,origpos):
		startpos,u,v,w,linelen = polydefs[0] # first edge
		drawlocus(origpos,u,v,w)
			
# createfrom3Dpoly
	closed = vs.IsPolyClosed(srcpolyH)
	origpos,polydefs = getpolydef(srcpolyH,closed)

	if convSF.Createlinarcs:
		grpH = vs.BeginGroupN(vs.Handle(0))
		drawlines3D(polydefs,closed)
		closegroup(grpH)
	
	if convSF.Createloci:
		grpH = vs.BeginGroupN(vs.Handle(0))
		if convSF.Vertexset:
			drawvertices3D(polydefs,closed)
		
		if convSF.Edgeset:
			drawedges3D(polydefs,closed)

		if convSF.Faceset:
			drawfaces3D(polydefs,origpos)
			
		closegroup(grpH)

# =================================createfrom3Dpoly

def createfromline(objH):
	entmat.refID = vs.GetPlanarRef(objH)
	locpt,entmat.u,entmat.w = vs.GetWorkingPlaneMat(entmat.refID)
	
	btest,ptloc1 = vs.PlanarPtTo3DModelPt(entmat.refID, vs.GetSegPt1(objH)) # start vertex 3D position
	btest,ptloc2 = vs.PlanarPtTo3DModelPt(entmat.refID, vs.GetSegPt2(objH)) # start vertex 3D position

	u = vs.UnitVec((ptloc2[X]-ptloc1[X],ptloc2[Y]-ptloc1[Y],ptloc2[Z]-ptloc1[Z]))
	v = vs.CrossProduct(u,entmat.w)
	v = (-v[X],-v[Y],-v[Z])

	linelen = vs.HLength(objH)

	#No Faceset
	grpH = vs.BeginGroupN(vs.Handle(0))

	if convSF.Createloci:
		if convSF.Vertexset:
			drawlocus(ptloc1,u,v,entmat.w)
			drawlocus(ptloc2,u,v,entmat.w)
	
		if convSF.Edgeset:
			spacesetout = convSF.Spacesetout
	
			spacing  = convSF.Spacing
			startpos = 0
	
			if spacesetout == convSF.kMIDDLE:
				spacing = startoffset = endoffset = 0
			else:
				spacing  = convSF.Spacing
				startoffset = convSF.Startoffset
				endoffset   = convSF.Endoffset
			
			edgelen = linelen - (startoffset + endoffset)
			if edgelen > 0:
				segstartpos,spaceno,spacing = getspacing(spacesetout,startpos,startoffset,edgelen)
				for loc in range(spaceno):
					offset = spacing*loc + segstartpos
					m = (u[X]*offset,u[Y]*offset,u[Z]*offset)
					ptloc3 = (ptloc1[X]+m[X],ptloc1[Y]+m[Y],ptloc1[Z]+m[Z])
					drawlocus(ptloc3,u,v,entmat.w)

	closegroup(grpH)

# =================================createfromline



def processcurve(objH):

	def getvecZ(objH):
		v1 = vs.NurbsGetPt3D(objH,0,0)
		v2 = vs.NurbsGetPt3D(objH,0,1)
		w = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
		w = (w[X],w[Y],abs(w[Z]))
	
		if vs.EqPt3D(w,(0.0,0.0,1.0),0.01):
			w = (1,0,0)
		else:
			pt2,z = vs.Get3DCntr(objH)
			u = (v1[X]-pt2[X],v1[Y]-pt2[Y],v1[Z]-z)
			v = (v2[X]-pt2[X],v2[Y]-pt2[Y],v2[Z]-z)
			w = vs.UnitVec(vs.CrossProduct(u,v))
	
		return w

	vectorw = getvecZ(objH)
	multinurbset = vs.NurbsCurveGetNumPieces(objH) > 1
	
	grpH = vs.BeginGroupN(vs.Handle(0))

	if multinurbset:
		polysH = vs.ConvertTo3DPolys(vs.CreateDuplicateObject(objH,vs.Handle(0)))
		objH = vs.FInGroup(polysH)
		curves = []
		while objH != vs.Handle(0):
			nobjH = vs.NextObj(objH)
			curves.append(vs.ConvertToNURBS(objH,False))
			objH = nobjH
	else:
		curves = [objH]

	if not convSF.Createlinarcs:
	# check
		for objH in curves:
			createfromcurve(objH,vectorw)
	
		if multinurbset:
			for objH in curves:
				vs.DelObject(objH)
	
	closegroup(grpH)

# =================================processcurve

def createfromcurve(curveH,vectorw):

	def getsymrotation(u,vectorw):
		v = vs.CrossProduct(u,vectorw)
		if v == (0,0,0):
			v = vs.Perp(u)
		w = vs.CrossProduct(u,v)

		return u,v,w
	
	def getpcent(pval):
		if pval == 1.0:
			pval = 1.0
		elif pval == 0.0:
			pval = 0.0

		return pval

	def getcurveclosed(curveH):
		v1 = vs.NurbsGetPt3D(curveH,0,0)
		vnum = vs.NurbsGetNumPts(curveH,0)
		v2 = vs.NurbsGetPt3D(curveH,0,vnum-1)

		return vs.EqPt3D(v1,v2,0.001)
	
	def chkstartendv(offlen,maxlen):
		return not (vs.Eq(offlen,0,0.001) or vs.Eq(offlen,maxlen,0.001))

	def drawnurbsspacing(pH,vectorw):

		spacing  = convSF.Spacing
		startoffset = convSF.Startoffset
		endoffset   = convSF.Endoffset

		numpieces = vs.NurbsCurveGetNumPieces(pH)
		maxcurvelen = vs.HLength(pH)
		curvelen = maxcurvelen - startoffset - endoffset

		spacesetout = convSF.Spacesetout
		spaceno = int(curvelen/spacing)+1

		if spacesetout == convSF.kMIDDLE:
			btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,0.5)
			btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,0.501)

			outvec  = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
			u,v,w = getsymrotation(outvec,vectorw)

			drawlocus(v1,u,v,w)

		elif spaceno > 0:
	
			if spacesetout == convSF.kSTART:
				offlen = startoffset

				for i in range(1,spaceno+1):
					pcent = getpcent(offlen/maxcurvelen)
					btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent)
					if chkstartendv(offlen,maxcurvelen):
						btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent+.001)
	
						outvec  = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
						u,v,w = getsymrotation(outvec,vectorw)
						drawlocus(v1,u,v,w)

					offlen += spacing
	
			elif spacesetout == convSF.kEND:
				offlen = maxcurvelen-endoffset

				for i in range(1,spaceno+1):
					pcent = getpcent(offlen/maxcurvelen)
					btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent)
					if chkstartendv(offlen,maxcurvelen):
						btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent+.001)
	
						outvec  = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
						u,v,w = getsymrotation(outvec,vectorw)
						drawlocus(v1,u,v,w)

					offlen -= spacing
	
			elif spacesetout == convSF.kCENTRED:
				offlen = startoffset + (curvelen - (spacing * spaceno))/2

				for i in range(1,spaceno+1):
					pcent = getpcent(offlen/maxcurvelen)
					btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent)
					if chkstartendv(offlen,maxcurvelen):
						btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent+.001)
						
						outvec  = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
						u,v,w = getsymrotation(outvec,vectorw)
						drawlocus(v1,u,v,w)

					offlen += spacing
	
			elif spacesetout == convSF.kEQUAL:
				spacing = curvelen/spaceno
				offlen = startoffset
				if endoffset > 0:
					spaceno += 2
				else:
					spaceno += 1

				for i in range(1,spaceno): #+1
					pcent = getpcent(offlen/maxcurvelen)
	
					btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent)
					if chkstartendv(offlen,maxcurvelen):
						if pcent+.01 > 1.0:
							btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent-0.001)
							v2 = (-v2[X],-v2[Y],-v2[Z])
						else:
							btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(pH,pcent+0.001)

						outvec  = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
						u,v,w = getsymrotation(outvec,vectorw)
						drawlocus(v1,u,v,w)

					offlen += spacing

	# drawnurbsspacing	
	
# createfromcurve
#	if convSF.Createlinarcs:

	if convSF.Createloci:
		if convSF.Vertexset:
			btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(curveH,0)
			btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(curveH,0.001)

			outvec  = vs.UnitVec((v2[X]-v1[X],v2[Y]-v1[Y],v2[Z]-v1[Z]))
			u,v,w = getsymrotation(outvec,vectorw)
			drawlocus(v1,u,v,w)

			if not getcurveclosed(curveH):
					btest,v1,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(curveH,1.0)
					btest,v2,uparam,outindex = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(curveH,0.999)
		
					outvec = vs.UnitVec((v1[X]-v2[X],v1[Y]-v2[Y],v1[Z]-v2[Z]))
					u,v,w = getsymrotation(outvec,vectorw)
					drawlocus(v1,u,v,w)
		
		if convSF.Edgeset:
				drawnurbsspacing(curveH,vectorw)

# =================================createfromcurve

def createfrom2Dpoly(srcpolyH):

# Poly check routines
	def chkinvis(polyH,maxvcnt):
		nonlocal polydef
		invcnt = 0
		linecnt = 0
		lastline = 0
		firstset = False

		for m in range(1,maxvcnt+1):
			visible = vs.GetVertexVisibility(polyH,m-1)
			vpos,vertextype,arcRadius = vs.GetPolylineVertex(polyH,m)
			polydef.append(vertexdef(visible,vertextype,vpos[X],vpos[Y],arcRadius))

			if not visible:
				invcnt += 1

			if (vertextype == 0): #line
				linecnt += 1
				if not visible:
					lastline = m
				if m == 1: #used for closed check
					firstset = True

		invisset = not ((invcnt == 0) or ((invcnt == 1) and not polydef[m].visible)) #polydef[maxvcnt].visible
		curveset = (linecnt <= 1)

		return invisset,curveset,lastline,firstset

	# chkinvis

	def getenddefs(splitset,polyclosed,maxvcnt,lastline):
		nonlocal enddefs
		nonlocal polydef
		vertcnt = 0

		if polyclosed: # all vertices are visible
			if splitset:
				vstart = 0
				for i in range(1,maxvcnt+1):
					if (polydef[i].vtype == 0):
						if vstart == 0:
							vstart = i
							inistart = i
						else:
							enddefs.append(multidef(vstart,i))
							vstart = i

				enddefs.append(multidef(vstart,inistart))

			else: # not multipolyset
				enddefs.append(multidef(1,maxvcnt))

		else: # multi polys
			#get start
			vstart = lastline

			while 1: #forever loop
				if (vstart + 1) > maxvcnt:
					vstart = 1
				else:
					vstart += 1
				vertcnt += 1
				if polydef[vstart].visible and (polydef[vstart].vtype == 0):
					break

			vref = vstart
			vend = vstart
			polystart = True

			while (vertcnt != maxvcnt):
				vertcnt += 1
				if (vref + 1) > maxvcnt:
					vref = 1
				else:
					vref += 1

				if (polydef[vref].vtype == 0):
					if polydef[vref].visible:
						if not polystart:
							vstart = vref
							polystart = True

						elif splitset and polydef[vstart].visible:
							enddefs.append(multidef(vstart,vref))
							vstart = vref
							polystart = True

					elif (not polydef[vref].visible) and polystart:
						enddefs.append(multidef(vstart,vref))
						polystart = False
			# while

		# multi polys
		
		# set linking
		entlen = len(enddefs)
		linkstart = enddefs[entlen-1].vend
		
		for entno in range(1,entlen):
			if entno < entlen-1:
				linkstart = enddefs[entno].vend
				linkend = enddefs[entno+1].vstart
			else:
				linkstart = enddefs[entlen-1].vend
				linkend = enddefs[Y].vstart

			enddefs[entno].linked = linkstart == linkend
			linkstart = enddefs[entno].vend

	# getenddefs
	
# Poly check routines

# Draw routines

	def addpolypt(px1,py1,vType,arcrad):
		if vType == 0:
			vs.LineTo(px1,py1)
		elif vType == 1:
			vs.CurveTo(px1,py1)
		elif vType == 2:
			vs.CurveThrough(px1,py1)
		elif vType == 3:
			vs.ArcTo(px1,py1,arcrad)
		elif vType == 4:
			vs.Add2DVertex(px1,py1,4,arcrad)
	#addpolypt

	def drawpoly2D(numvert):
		nonlocal enddefs
		nonlocal polydef

		vs.OpenPoly()
		pathcnt = len(enddefs)

		for p in range(1,pathcnt):
			vstart = enddefs[p].vstart
			vend = enddefs[p].vend

			if ((vstart == numvert) and (vend == 1)) or ((vend - vstart) == 1):
				vs.MoveTo(polydef[vstart].x,polydef[vstart].y)
				vs.LineTo(polydef[vend].x,polydef[vend].y)
				vs.SetEntityMatrix(vs.LNewObj(),entmat.offset,entmat.rotx,entmat.roty,entmat.rotz)
			else:
				vertcnt = vstart
				vs.BeginPoly()
				vs.MoveTo(polydef[vertcnt].x,polydef[vertcnt].y)

				while 1:
					if (vertcnt == numvert):
						vertcnt = 1
					else:
						vertcnt += 1
					addpolypt(polydef[vertcnt].x,polydef[vertcnt].y,polydef[vertcnt].vtype,polydef[vertcnt].arcrad)
					if (vertcnt == vend):
						break

				vs.EndPoly()
				vs.SetEntityMatrix(vs.LNewObj(),entmat.offset,entmat.rotx,entmat.roty,entmat.rotz)

		# for p
	
	# drawpoly2D
	
	def drawvertices2D(holeset,clockwise,polyH,closed,vnum,perim):
		nonlocal enddefs
		nonlocal polydef

		def getvertmatrix(holeset,clockwise,centpt,ptbefore,ptloc,ptafter):
			if ptbefore == None:
				v1 = (ptafter[X]-ptloc[X],ptafter[Y]-ptloc[Y],ptafter[Z]-ptloc[Z])

			elif ptafter == None:
				v1 = (ptloc[X]-ptbefore[X],ptloc[Y]-ptbefore[Y],ptloc[Z]-ptbefore[Z])

			else:
				v1 = (ptafter[X]-ptbefore[X],ptafter[Y]-ptbefore[Y],ptafter[Z]-ptbefore[Z])

			v2 = (centpt[X]-ptloc[X],centpt[Y]-ptloc[Y],centpt[Z]-ptloc[Z])
			v3 = vs.CrossProduct(v1, v2)
			v2 = vs.CrossProduct(v1, v3)

			mati = vs.UnitVec(v1)
			matj = vs.UnitVec(v2)
			matk = vs.UnitVec(v3)
			
			if holeset:
				if entmat.clockwise == clockwise: #same direction
					mati = (-mati[X],-mati[Y],-mati[Z])
					matj = (-matj[X],-matj[Y],-matj[Z])
				elif not clockwise:
					mati = (-mati[X],-mati[Y],-mati[Z])
					matj = (-matj[X],-matj[Y],-matj[Z])
					matk = (-matk[X],-matk[Y],-matk[Z])
			else: # outer poly
				if not clockwise:
					matj = (-matj[X],-matj[Y],-matj[Z])
					matk = (-matk[X],-matk[Y],-matk[Z])

			return(mati,matj,matk)

		#getvertmatrix

		def getvertpositions(polyH,beforelen,afterlen):
			EPSILON = 0.0001

			if beforelen != None:
				btest, ptemp, beforevec = vs.PointAlongPolyN(polyH,beforelen,EPSILON) # in 2D Z = 0
				btest,ptbefore = vs.PlanarPtTo3DModelPt(entmat.refID, (ptemp[X],ptemp[Y])) # vertex 3D position
			else:
				ptbefore = None
				
			if afterlen != None:
				btest, ptemp,aftervec = vs.PointAlongPolyN(polyH,afterlen,EPSILON) # in 2D Z = 0
				btest,ptafter = vs.PlanarPtTo3DModelPt(entmat.refID, (ptemp[X],ptemp[Y])) # vertex 3D position
			else:
				ptafter = None
			
			return ptbefore,ptafter

		#getvertpositions
		
		def getvertdefs(startset,prevlinked,linked,polyH,vno,perim):
			nonlocal lenoffset

			if vno == 1:
				beforelen = perim-lenoffset
				afterlen  = lenoffset
			else:
				seglen = vs.CalcPolySegLen(polyH,1,vno)
				beforelen = seglen - lenoffset
				afterlen  = seglen + lenoffset
			
			if startset and not prevlinked:
				beforelen = None
			elif not startset and not linked:
				afterlen = None

			return beforelen,afterlen

		#getvertdefs

	# drawvertices2D
		pathcnt = len(enddefs)
		lenoffset = mm(200)
		curvno = 0

		btest,cx1,cy1 = vs.Centroid(polyH)
		btest,centpt = vs.PlanarPtTo3DModelPt(entmat.refID, (cx1,cy1))
		lastvert = (centpt[X],centpt[Y])

		prevlinked = enddefs[pathcnt-1].linked

		for p in range(1,pathcnt):
			vstart = enddefs[p].vstart
			vend = enddefs[p].vend
			linked = enddefs[p].linked #to next

			# always draw start
			beforelen,afterlen = getvertdefs(True,prevlinked,linked,polyH,vstart,perim)
			ptbefore,ptafter = getvertpositions(polyH,beforelen,afterlen)
			
			btest,ptloc = vs.PlanarPtTo3DModelPt(entmat.refID, (polydef[vstart].x,polydef[vstart].y))

			u,v,w = getvertmatrix(holeset,clockwise,centpt,ptbefore,ptloc,ptafter)
			w = (-w[X],-w[Y],-w[Z])
			drawlocus(ptloc,u,v,w)

			if not linked:
				beforelen,afterlen = getvertdefs(False,prevlinked,linked,polyH,vend,perim)
				ptbefore,ptafter = getvertpositions(polyH,beforelen,afterlen)

				btest,ptloc = vs.PlanarPtTo3DModelPt(entmat.refID, (polydef[vend].x,polydef[vend].y))
				u,v,w = getvertmatrix(holeset,clockwise,centpt,ptbefore,ptloc,ptafter)
				w = (-w[X],-w[Y],-w[Z])
				drawlocus(ptloc,u,v,w)
			
			prevlinked = linked

	# drawvertices2D
		
	def drawedges2D(holeset,clockwise,polyH,perim):
		nonlocal enddefs

		pathcnt = len(enddefs)
		startpos = 0
		spacesetout = convSF.Spacesetout

		if spacesetout == convSF.kMIDDLE:
			spacing = startoffset = endoffset = 0
		else:
			spacing  = convSF.Spacing
			startoffset = convSF.Startoffset
			endoffset   = convSF.Endoffset
		
		for p in range(1,pathcnt):
			vstart = enddefs[p].vstart
			vend = enddefs[p].vend
			if vstart == 1:
				startpos = 0
			else:
				startpos = vs.CalcPolySegLen(polyH,1,vstart)

			if vend < vstart:
				seglen = perim - vs.CalcPolySegLen(polyH,vend,vstart)
			else:
				seglen = vs.CalcPolySegLen(polyH,vstart,vend)

			edgelen = seglen - (startoffset + endoffset)

			if edgelen > 0:
				segstartpos,spaceno,spacing = getspacing(spacesetout,startpos,startoffset,edgelen)

				for loc in range(spaceno):
					btest,ppos,u = vs.PointAlongPolyN(polyH,segstartpos,0.001)

					if btest:
						btest,ptloc = vs.PlanarPtTo3DModelPt(entmat.refID,ppos)
						tpos = (ppos[X]+u[X],ppos[Y]+u[Y],ppos[Z]+u[Z])


						btest,ptloc2 = vs.PlanarPtTo3DModelPt(entmat.refID,tpos)
						u = vs.UnitVec((ptloc2[X]-ptloc[X],ptloc2[Y]-ptloc[Y],ptloc2[Z]-ptloc[Z]))
						w = entmat.w
						v = vs.CrossProduct(u,w)

						if holeset:
							if clockwise != entmat.clockwise:
								w = (-w[X],-w[Y],-w[Z])
								v = (-v[X],-v[Y],-v[Z])
							else:
								u = (-u[X],-u[Y],-u[Z])
						else:
							v = (-v[X],-v[Y],-v[Z])
						
						drawlocus(ptloc,u,v,w)

					segstartpos += spacing

	#drawedges2D

	def drawfaces2D(polyH):
		btest,cx1,cy1 = vs.Centroid(polyH)
		if btest:
			btest,ptloc = vs.PlanarPtTo3DModelPt(entmat.refID, (cx1,cy1))
			v = (-entmat.v[X],-entmat.v[Y],-entmat.v[Z])
			drawlocus(ptloc,entmat.u,v,entmat.w)

	#drawfaces2D
		

# Draw routines
	
	def createpolys(holeset,polyH,perim):
		
		def IsClosed(pH,vertnum):
			btest = True
			for vno in range(vertnum):
				btest = vs.GetVertexVisibility(pH,vno)
				if not btest:
					break
			if btest:
				btest = vs.IsPolyClosed(pH)
			return btest
	
		# IsClosed
		
		def reorderclosedpoly(polyH,vstart,vnum):

			nonlocal polydef
			nonlocal enddefs
			polydef = [0] #to align 1 to n
			enddefs = [0]

			vs.ClosePoly()
			vs.BeginPoly()

			vno = vstart
			vend = 0

			for i in range(1,vnum+1):
				vpos,vertextype,arcRadius = vs.GetPolylineVertex(polyH,vno)
				polydef.append(vertexdef(True,vertextype,vpos[X],vpos[Y],arcRadius))
				
				if i == 1:
					addpolypt(vpos[X],vpos[Y],vertextype,arcRadius)
					vstart = 1
				else:
					addpolypt(vpos[X],vpos[Y],vertextype,arcRadius)
					if vertextype == 0:
						vend = i
						enddefs.append(multidef(vstart,i,True))
						vstart = i

				if vno == vnum:
					vno = 1
				else:
					vno += 1

			enddefs.append(multidef(vstart,1,True))
			vs.EndPoly()

			polyH = vs.LNewObj()
			vs.SetDSelect(polyH)

			return polyH

		#reorderclosedpoly
	
	# createpolys
		nonlocal polydef
		nonlocal enddefs
		
		polydef = [0] #to align 1 to n
		enddefs = [0]
	
		vnum = vs.GetVertNum(polyH)
		closed = IsClosed(polyH,vnum)
		clockwise = vs.GetObjectVariableBoolean(polyH,652)
		
		multipolyset,allcurved,lastlineref,firstset = chkinvis(polyH,vnum)

		splitatvertex = True
		if (multipolyset or splitatvertex) and not allcurved:
			getenddefs(splitatvertex,closed,vnum,lastlineref)
		else:
			enddefs.append(multidef(1,vnum))
		
		if convSF.Createlinarcs:
			grpH = vs.BeginGroupN(vs.Handle(0))
			if len(enddefs) == 2: # single poly as copy
				vs.SetSelect(vs.CreateDuplicateObject(pH,vs.Handle(0)))
			else:
				drawpoly2D(vnum) # multi poly
			closegroup(grpH)
		
		if convSF.Createloci:
				grpH = vs.Handle(0)
				if convSF.Vertexset and not allcurved:
					if not closed:
						polyH = vs.CreateDuplicateObject(polyH,vs.Handle(0))
						for i in range(vnum):
							if vs.GetVertexVisibility(polyH,i):
								vs.SetVertexVisibility(polyH,i,True)
					elif closed and not firstset:
						polyH = reorderclosedpoly(polyH,enddefs[Y].vstart,vnum)

					grpH = vs.BeginGroupN(grpH)
					drawvertices2D(holeset,clockwise,polyH,closed,vnum,perim)
					
					if not closed or closed and not firstset:
						vs.DelObject(polyH)
				
				if convSF.Edgeset:
					grpH = vs.BeginGroupN(grpH)
					drawedges2D(holeset,clockwise,polyH,perim)
		
				if convSF.Faceset and closed and (entmat.numholes == 0): # only closed polys with no holes
					grpH = vs.BeginGroupN(grpH)
					drawfaces2D(polyH)

				closegroup(grpH)
	
	# createpolys

# createfrom2Dpoly
	polydef = []
	enddefs = []
	
	entmat.clockwise = vs.GetObjectVariableBoolean(srcpolyH,652)

	btest,entmat.offset,entmat.rotx,entmat.roty,entmat.rotz = vs.GetEntityMatrix(srcpolyH)
	entmat.refID = vs.GetPlanarRef(srcpolyH)

	locpt,entmat.u,entmat.w = vs.GetWorkingPlaneMat(entmat.refID)
	entmat.v = vs.CrossProduct(entmat.u,entmat.w)

	holeperim = 0
	btest,entmat.numholes = vs.GetNumHoles(srcpolyH)
	if btest:
		# split out holes and reverse direction
		for i in range(entmat.numholes):
			btest,holeH = vs.GetHole(srcpolyH,i+1)
			if btest:
				perim = vs.HPerimN(holeH)
				holeperim += perim
				createpolys(True,holeH,perim)

	perim = vs.HPerimN(srcpolyH) - holeperim
	createpolys(False,srcpolyH,perim)

# =================================createfrom2Dpoly

# ===============================================================Shape conversion


# ===============================================================Solid conversion

def getpolydefs(srcH):
	polys = []
	if vs.GetTypeN(srcH) == 11: # group
		objH = vs.FInGroup(srcH)
		while objH != vs.Handle(0):
			tempH = vs.NextObj(objH)
			polys.append(objH)
			objH = tempH
	else:
		polys = [srcH] # single object
	return polys

def createfromlinked(polys):

	def addvertex(vert,fcnt):
		nonlocal verts
		nonlocal vertfaces

		def vertinverts(refvert,verts):
			vref = []
			for i in range(len(verts)):
				v1 = (refvert[0],refvert[1],refvert[2])
				v2 = (verts[i][0],verts[i][1],verts[i][2])
				if vs.EqPt3D(v1,v2,0.00001): # used for rounding
					vref = i
					break
			return vref

		vref = vertinverts(vert,verts)
		if vref != []:
			if fcnt not in vertfaces[vref]:
				vertfaces[vref].append(fcnt)
		else:
			verts.append(vert) # add to vertex list
			fref = [fcnt]
			vertfaces.append(fref)
			vref = len(verts)-1 # first in vertex list

		return vref
		# addvertex

	def setedgevec(edge):
		nonlocal verts
		nonlocal edgevecs

		pt1 = verts[edge[0]]
		pt2 = verts[edge[1]]
		
		vec = (pt2[0]-pt1[0],pt2[1]-pt1[1],pt2[2]-pt1[2])
		midpos = (pt1[0]+vec[0]/2,pt1[1]+vec[1]/2,pt1[2]+vec[2]/2)
		edgevec = vs.UnitVec(vec)

		# store edge mid position and edge delta X axis direction
		edgevecs.append((midpos,edgevec))

		return
		# setedgevec
			
	def addedge(edge,fcnt):
		nonlocal edges
		nonlocal edgefaces

		if edge[0] > edge[1]: # order low to high
			edge = (edge[1],edge[0])

		if edge in edges:
			edgeref = edges.index(edge)
			if fcnt not in edgefaces[edgeref]:
				edgefaces[edgeref].append(fcnt)
			else:
				fdef = [fcnt]
				edgefaces[edgeref] = fdef # new entry
		else:
			edges.append(edge) # add to edge list
			setedgevec(edge)

			fdef = [fcnt]
			edgefaces.append(fdef)

		return
		# addedge

	def getfacedef(faceH,fcnt):
		nonlocal faces

		pt1 = vs.GetPolyPt3D(faceH,0)
		pt2 = vs.GetPolyPt3D(faceH,1)
		centpos = get3Dpolycentroid(faceH)
		xaxis,yaxis,zaxis,linelen = getmatrix(pt1,pt2,centpos)

		vlocfrom = addvertex(pt1,fcnt)
		startfrom = vlocfrom
		vlocto   = addvertex(pt2,fcnt)
		
		addedge((vlocfrom,vlocto),fcnt)
		faces.append((xaxis,yaxis,zaxis,centpos))
		vlocfrom = vlocto

		vcnt = vs.GetVertNum(faceH)
		for i in range(2,vcnt):
			vert = vs.GetPolyPt3D(faceH, i)
			vlocto   = addvertex(vert,fcnt)
			addedge((vlocfrom,vlocto),fcnt)
			vlocfrom = vlocto

		addedge((vlocfrom,startfrom),fcnt) # close polygon

		return
		#getfacedef
	
	def getfaceedgeref(facerefs): #edited 220822
		nonlocal edgefaces
		nonlocal edgevecs
		firstface = facerefs[0] # returns integer

		for j in range(len(edgefaces)):
			try:
				if edgefaces[j][0] == firstface or edgefaces[j][1] == firstface: #error index out of range 220818
					firstedge = edgevecs[j][1]
					break
			except IndexError as e:
				firstedge =  0 #default

		return firstedge

	def drawline(startpos,linelen,u,v,w):
		vs.MoveTo(0,0)
		vs.LineTo(linelen,0)
		lineH = vs.LNewObj()
		btest = vs.SetEntityMatrixN(lineH, u, v, w, startpos)
		if not btest:
			vs.DelObject(lineH)

	def addvec(vecdir,axis):
		return (vecdir[0] + axis[0],vecdir[1] + axis[1],vecdir[2] + axis[2])
		
	def getpolydefs(srcH):
		polys = []
		if vs.GetTypeN(srcH) == 11: # group
			objH = vs.FInGroup(srcH)
			while objH != vs.Handle(0):
				tempH = vs.NextObj(objH)
				polys.append(objH)
				objH = tempH
		else:
			polys = [srcH] # single object
		return polys
	
# =================================createfromlinked
	faces = [] 		# face entry 	= (xaxis,yaxis,zaxis,centpos)...
	# need faceedges  face entry

	edges = [] 		# edge entry 	= (fromvertno,tovertno)...
	edgevecs  = [] 	# edge entry 	= (midpos,edgevec)...
	edgefaces = [] 	# edge entry 	= [faceno1,faceno2],...

	verts = [] 		# vertex entry 	= (vertexpos)...
	vertfaces = []	# vertex entry	= [faceno1,faceno2,..faceN],...

	polynum = len(polys)
	for i in range(polynum):
		getfacedef(polys[i],i)
	
	if convSF.Createlinarcs:
		grpH = vs.BeginGroupN(vs.Handle(0)) # line group
		for i in range(len(edges)):
			edge = edges[i]
			startpos 	= verts[edge[0]]
			endpos 		= verts[edge[1]]
			linelen 	= vs.Distance3D(startpos[0],startpos[1],startpos[2],endpos[0],endpos[1],endpos[2])
			xdir = edgevecs[i][1]

			# get combined zdir of all linked faces
			zdir = (0,0,0)
			edgedef = edgefaces[i]
			for faceno in edgedef:
				xaxis,yaxis,zaxis,centpos = faces[faceno]
				zdir = addvec(zdir,zaxis)	
			zdir = vs.UnitVec(zdir)
			ydir = vs.CrossProduct(xdir,zdir) # always returns unit vector?
			ydir = (-ydir[X],-ydir[Y],-ydir[Z])
			lineH = drawline(startpos,linelen,xdir,ydir,zdir)

		closegroup(grpH)

	if convSF.Createloci:
		grpH = vs.BeginGroupN(vs.Handle(0)) # loci group

		if convSF.Vertexset:
			for i in range(len(vertfaces)):
				zdir = (0,0,0)
				facerefs = vertfaces[i]
				xdir = getfaceedgeref(facerefs)	
				vertpos = verts[i]
				for j in range(len(facerefs)):
					faceno = facerefs[j]
					xaxis,yaxis,zaxis,centpos = faces[faceno]
					zdir = addvec(zdir,zaxis)	
				zdir = vs.UnitVec((-zdir[X],-zdir[Y],-zdir[Z])) #zdir
				ydir = vs.CrossProduct(xdir,zdir) # always returns unit vector?
				xdir = vs.CrossProduct(ydir,zdir)
				drawlocus(vertpos,xdir,ydir,zdir)

		if convSF.Edgeset:
			for i in range(len(edges)):
				startvert = edges[i][0]
				endvert = edges[i][1]
				ptloc1 = verts[startvert]
				ptloc2 = verts[endvert]

				spacesetout = convSF.Spacesetout
		
				spacing  = convSF.Spacing
				startpos = 0
		
				if spacesetout == convSF.kMIDDLE:
					spacing = startoffset = endoffset = 0
				else:
					spacing  = convSF.Spacing
					startoffset = convSF.Startoffset
					endoffset   = convSF.Endoffset

				linelen = vs.Distance3D(ptloc1[X],ptloc1[Y],ptloc1[Z],ptloc2[X],ptloc2[Y],ptloc2[Z])
				edgelen = linelen - (startoffset + endoffset)
				if edgelen > 0:

					midpos,u = edgevecs[i]
					linkfaces = edgefaces[i]

					xaxis,yaxis,zaxis,centpos = faces[linkfaces[0]]
					w = zaxis
					if (len(faces) > 1) and (len(linkfaces) > 1): #edited 220822
						xaxis2,yaxis2,zaxis2,centpos = faces[linkfaces[1]]
						w = vs.UnitVec((w[X]+zaxis2[X],w[Y]+zaxis2[Y],w[Z]+zaxis2[Z]))
					v = vs.CrossProduct(u,w)
					
					segstartpos,spaceno,spacing = getspacing(spacesetout,startpos,startoffset,edgelen)
					for loc in range(spaceno):
						offset = spacing*loc + segstartpos
						m = (u[X]*offset,u[Y]*offset,u[Z]*offset)
						ptloc3 = (ptloc1[X]+m[X],ptloc1[Y]+m[Y],ptloc1[Z]+m[Z])
						drawlocus(ptloc3,u,v,w)

		if convSF.Faceset:
			for polyH in polys:
				origpos = get3Dpolycentroid(polyH)
				startpos = vs.GetPolyPt3D(polyH,0)
				endpos = vs.GetPolyPt3D(polyH,1)
				u,v,w,linelen = getmatrix(startpos,endpos,origpos)

				drawlocus(origpos,u,v,w)

		closegroup(grpH)

# =================================createfromlinked
		
def createfromsolid(srcH,Uselinkedfaces):
	tempH = vs.CreateDuplicateObject(srcH,vs.Handle(0))
	objH  = vs.ConvertTo3DPolys(tempH) # multi 3D polygons
	polys = getpolydefs(objH)
	
	grpH = vs.BeginGroupN(vs.Handle(0))
	
	if Uselinkedfaces:
		createfromlinked(polys)
	else:
		for polyH in polys:
			if not vs.IsPolyClosed(polyH):
				vs.SetPolyClosed(polyH,True) # set poly closed always added 230210
			createfrom3Dpoly(polyH)
	
	vs.DelObject(objH)

	closegroup(grpH)

# =================================createfromsolid


# ===============================================================Solid conversion
